/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.steps;

import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.event.IVWMapChangedListener;
import filenet.vw.toolkit.design.property.event.VWMapChangedEvent;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.VWMapListCellRenderer;
import filenet.vw.toolkit.utils.VWInstruction;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class VWMapSelectionPanel
extends JPanel
implements ActionListener,
IVWToolbarBorderActionListener,
IVWMapChangedListener {
    protected VWToolbarBorder m_mapBorder = null;
    protected JComboBox m_mapComboBox = null;
    protected JButton m_goToButton = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWInstructionDefinition m_instructionDef = null;
    private Vector m_controls = null;
    private boolean m_bAddingMap = false;

    public VWMapSelectionPanel(VWAuthPropertyData authPropertyData) {
        this.m_authPropertyData = authPropertyData;
        this.m_controls = new Vector();
        this.setLayout(new BorderLayout());
        JPanel childPanel = this.getSubmapPanel();
        this.add((Component)childPanel, "First");
        this.m_authPropertyData.getMapChangeEventNotifier().addMapChangedListener(this);
    }

    public void setEnabled(boolean bEnable) {
        super.setEnabled(bEnable);
        if (this.m_controls == null) {
            return;
        }
        boolean bEnableControls = false;
        if (bEnable && this.m_mapComboBox != null && this.m_mapComboBox.getItemCount() > 0) {
            bEnableControls = true;
        }
        for (int i = 0; i < this.m_controls.size(); ++i) {
            JComponent component = (JComponent)this.m_controls.elementAt(i);
            if (component == null) continue;
            component.setEnabled(bEnableControls);
        }
        if (this.m_mapBorder != null) {
            int nEnableFlag = 2;
            if (bEnableControls) {
                nEnableFlag = 1;
            }
            this.m_mapBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_mapBorder.getClientPanel(), nEnableFlag, 16));
        }
    }

    public void releaseReferences() {
        this.m_authPropertyData.getMapChangeEventNotifier().removeMapChangedListener(this);
        if (this.m_controls != null) {
            this.m_controls.removeAllElements();
            this.m_controls = null;
        }
        if (this.m_mapBorder != null) {
            this.m_mapBorder.removeToolbarBorderActionNotifier(this);
            this.m_mapBorder.removeAll();
            this.m_mapBorder = null;
        }
        if (this.m_mapComboBox != null) {
            this.m_mapComboBox.removeActionListener(this);
            this.m_mapComboBox.removeAllItems();
            this.m_mapComboBox = null;
        }
        if (this.m_goToButton != null) {
            this.m_goToButton.removeActionListener(this);
            this.m_goToButton = null;
        }
        this.removeAll();
    }

    public void setInstructionDefinition(VWInstructionDefinition instructionDef) {
        String mapName;
        this.m_instructionDef = instructionDef;
        this.initMapComboBox();
        this.m_mapComboBox.removeActionListener(this);
        this.m_goToButton.setEnabled(false);
        boolean bSelected = false;
        if (this.m_instructionDef != null && (mapName = VWInstruction.CallInstructionGetSubmap(this.m_instructionDef)) != null) {
            if (mapName.length() > 0) {
                DefaultComboBoxModel cbModel = (DefaultComboBoxModel)this.m_mapComboBox.getModel();
                if (cbModel != null && cbModel.getIndexOf(mapName) == -1) {
                    this.m_mapComboBox.insertItemAt(mapName, 4);
                }
                this.m_mapComboBox.setSelectedItem(mapName);
                bSelected = true;
                this.verifyMapSelection();
            } else {
                VWInstruction.CallInstructionSetSubmap(this.m_instructionDef, null);
            }
        }
        if (!bSelected) {
            this.m_mapComboBox.setSelectedIndex(0);
        }
        this.m_mapComboBox.addActionListener(this);
    }

    public void mapChanged(VWMapChangedEvent event) {
        switch (event.getID()) {
            case 516: {
                Vector params;
                this.initMapComboBox();
                if (!this.m_bAddingMap || (params = event.getEventParams()) == null || params.size() <= 0 || !(params.elementAt(0) instanceof VWMapDefinition)) break;
                VWMapDefinition mapDef = (VWMapDefinition)params.elementAt(0);
                this.m_mapComboBox.setSelectedItem(mapDef.getName());
                this.performGotoAction();
                break;
            }
            case 517: 
            case 519: {
                this.initMapComboBox();
                this.setInstructionDefinition(this.m_instructionDef);
            }
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            if (event.getSource() == this.m_mapBorder) {
                switch (event.getID()) {
                    case 16: {
                        this.performCreateMap();
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getSource().equals(this.m_mapComboBox)) {
                this.onMapComboBox();
            } else if (event.getSource().equals(this.m_goToButton)) {
                this.performGotoAction();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getSubmapPanel() {
        this.m_mapBorder = new VWToolbarBorder(VWResource.s_selectMapForSubmap, 16);
        this.m_mapBorder.setTooltip(16, VWResource.s_createSubmap);
        this.m_mapBorder.addToolbarBorderActionNotifier(this);
        JPanel clientPanel = this.m_mapBorder.getClientPanel();
        clientPanel.setLayout(new BorderLayout(5, 5));
        this.m_controls.addElement(this.m_mapBorder);
        this.m_mapComboBox = new JComboBox();
        this.m_mapComboBox.setName("m_mapComboBox_VWMapSelectionPanel");
        this.m_mapComboBox.setRenderer(new VWMapListCellRenderer(this.m_authPropertyData));
        this.m_mapComboBox.addActionListener(this);
        this.m_controls.addElement(this.m_mapComboBox);
        clientPanel.add((Component)this.m_mapComboBox, "Center");
        this.m_goToButton = VWImageLoader.createIconButton("goto.gif", VWResource.s_gotoSubmapStr);
        this.m_goToButton.setName("m_goToButton_VWMapSelectionPanel");
        this.m_goToButton.setEnabled(false);
        this.m_goToButton.addActionListener(this);
        this.m_controls.addElement(this.m_goToButton);
        clientPanel.add((Component)this.m_goToButton, "After");
        return this.m_mapBorder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMapComboBox() {
        try {
            try {
                this.m_mapComboBox.removeActionListener(this);
                if (this.m_authPropertyData != null) {
                    Object mapName;
                    int i;
                    this.m_mapComboBox.removeAllItems();
                    this.m_mapComboBox.addItem(VWResource.s_noneItemStr);
                    this.m_mapComboBox.addItem("Workflow");
                    this.m_mapComboBox.addItem("Malfunction");
                    this.m_mapComboBox.addItem("Terminate");
                    Object[] mapNames = null;
                    Vector<Object> mapNamesVec = new Vector<Object>();
                    VWMapDefinition[] mapDefs = this.m_authPropertyData.getMapCache().getMapDefinitions();
                    if (mapDefs != null) {
                        for (i = 0; i < mapDefs.length; ++i) {
                            mapName = mapDefs[i].getName();
                            if (VWStringUtils.compare((String)mapName, "Workflow") == 0 || VWStringUtils.compare((String)mapName, "Malfunction") == 0 || VWStringUtils.compare((String)mapName, "Terminate") == 0) continue;
                            mapNamesVec.addElement(mapName);
                        }
                        mapNames = new String[mapNamesVec.size()];
                        mapNamesVec.copyInto(mapNames);
                    }
                    if (mapNames != null && mapNames.length > 0) {
                        VWQubbleSort.sort(mapNames);
                        for (i = 0; i < mapNames.length; ++i) {
                            mapName = mapNames[i];
                            if (VWStringUtils.compareIgnoreCase((String)mapName, "") == 0) continue;
                            this.m_mapComboBox.addItem(mapName);
                        }
                    }
                }
                Object var7_7 = null;
                this.m_mapComboBox.addActionListener(this);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var7_8 = null;
                this.m_mapComboBox.addActionListener(this);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.m_mapComboBox.addActionListener(this);
            throw throwable;
        }
    }

    private void onMapComboBox() {
        try {
            String mapName = this.verifyMapSelection();
            VWInstruction.CallInstructionSetSubmap(this.m_instructionDef, mapName);
            this.m_authPropertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private String verifyMapSelection() {
        this.m_goToButton.setEnabled(false);
        String mapName = this.m_mapComboBox.getSelectedItem().toString();
        if (VWStringUtils.compare(mapName, VWResource.s_noneItemStr) != 0) {
            boolean bFound = false;
            if (this.m_authPropertyData.getMapCache().isMapExist(mapName, true)) {
                bFound = true;
            }
            if (bFound) {
                this.m_goToButton.setEnabled(true);
            }
        } else {
            mapName = null;
        }
        return mapName;
    }

    protected void performCreateMap() {
        this.m_bAddingMap = true;
        this.m_authPropertyData.getToolbarActionNotifier().notifyToolbarAction(this, 500);
        this.m_bAddingMap = false;
    }

    private void performGotoAction() {
        try {
            String mapName = (String)this.m_mapComboBox.getSelectedItem();
            this.m_authPropertyData.getToolbarActionNotifier().notifyToolbarAction(this, 503, mapName);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

